unit Sugo_Pld;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, Buttons, StdCtrls, ExtCtrls, ImgList, ActnList;

type
  TForm1 = class(TForm)
    imlRozsa: TImageList;
    imlKutyus: TImageList;
    imlKiadojel: TImageList;
    imgKep: TImage;
    cmdStart: TButton;
    MainMenu1: TMainMenu;
    mnuFajl: TMenuItem;
    mnuKilep: TMenuItem;
    mnuKep: TMenuItem;
    mnuRozsa: TMenuItem;
    mnuKutyus: TMenuItem;
    mnuKiadojel: TMenuItem;
    mnuTetelek: TMenuItem;
    mnuTetel1: TMenuItem;
    mnuTetel2: TMenuItem;
    mnuTobbTetel: TMenuItem;
    mnuIndex: TMenuItem;
    mnuTemakorok: TMenuItem;
    tmrIdozito: TTimer;
    PopupMenu1: TPopupMenu;
    pmnuMiez: TMenuItem;
    mnuSzeparator: TMenuItem;
    mnuMiez: TMenuItem;
    procedure cmdStartClick(Sender: TObject);
    procedure mnuKilepClick(Sender: TObject);
    procedure mnuTetelClick(Sender: TObject);
    procedure mnuTemakorokClick(Sender: TObject);
    procedure tmrIdozitoTimer(Sender: TObject);
    procedure pmnuMiezClick(Sender: TObject);
    procedure mnuMiezClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure imgKepClick(Sender: TObject);
    procedure mnuKepsorozatClick(Sender: TObject);

  private
     { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation
const
  KepSzam = 3;
var
  Kocka: array [1..KepSzam] of integer;
  ElojelesEgy: array [1..KepSzam] of integer;
  Forgando: TImageList;
  Forgo: Longint;
{$R *.DFM}


procedure TForm1.mnuKilepClick(Sender: TObject);
 begin
   Form1.Close;
 end;

procedure MiEzAllapotKikapcsolasa;
begin
 if Screen.Cursor=crHelp then
  begin
    Screen.Cursor:=crDefault;
    Form1.mnuMiEz.Checked:= false;
  end;
end;

procedure TForm1.mnuTetelClick(Sender: TObject);
begin
  MiEzAllapotKikapcsolasa;
  Application.HelpFile := 'tetelek.hlp';    // sgfjl neve
  // Kontextszmnak megfelel ttel megjelentse:
  Application.HelpCommand(HELP_CONTEXT, (Sender as TMenuItem).HelpContext);
end;

procedure TForm1.mnuTemakorokClick(Sender: TObject);
begin
  MiEzAllapotKikapcsolasa;
  Application.HelpFile := 'sugo_pld.hlp';    // sgfjl neve
  // A sgablak Tartalom, illetve Trgymutat lapjn val megnyitsa:
  Application.HelpCommand(HELP_FINDER, 0);
end;

procedure KepMegjelenites(Kocka:integer; Lista: TImageList);
begin
  // a Kocka-dik kpkocka megjelentse:
  Lista.GetBitmap(Kocka, Form1.imgKep.Picture.Bitmap);
  Form1.imgKep.Refresh;
  Forgando:= Lista;
end;

procedure TForm1.tmrIdozitoTimer(Sender: TObject);
begin
 // Szmll rtknek nvelse/cskkense:
 Kocka[Forgo] := Kocka[Forgo] + ElojelesEgy[Forgo];

 case Forgo of
  2: Kocka[Forgo]:=Kocka[Forgo] mod Forgando.Count;
  1, 3: { Ha elrtk a kpsorozat els, illetve utols
          kpkockt (az i szmll tllpte a sorozat
          als, illetve fels indexhatrt):}
     if (Kocka[Forgo] = -1) or (Kocka[Forgo] = Forgando.Count) then
      begin
        // Forgsirny vltsa:
        ElojelesEgy[Forgo]:= ElojelesEgy[Forgo]*(-1);
        // Visszalps a msodik, illetve az utols eltti kpkockra:
        Kocka[Forgo]:= Kocka[Forgo]+2*ElojelesEgy[Forgo];
      end;
 end;
 // A Kocka index kpkocka megjelentse:
 KepMegjelenites(Kocka[Forgo], Forgando);
end;

procedure TForm1.pmnuMiezClick(Sender: TObject);
begin
 // A megjelentend sgfjl nevnek megadsa:
 Application.HelpFile := 'KONTEXT.HLP';
 // Sghvs: WinHelp32.EXE futtatsa s a megadott kontextszm sgfejezet megjelentse:
  with PopupMenu1 do
   if PopupComponent is TButton
    then Application.HelpCommand(HELP_CONTEXTPOPUP, (PopupComponent as TWinControl).HelpContext)
    else
     if PopupComponent is TImage
      then Application.HelpCommand(HELP_CONTEXTPOPUP, (PopupComponent as TComponent).Tag);
end;

procedure TForm1.cmdStartClick(Sender: TObject);
Const
  szStartStop: array [0..1] of string = ('Start', 'Stop');
  i: integer = 0;
begin
 if Screen.Cursor=crHelp then
  begin
    Application.HelpFile := 'kontext.hlp';
    Application.HelpCommand(HELP_CONTEXTPOPUP, cmdStart.HelpContext);
    MiEzAllapotKikapcsolasa;
  end
 else
  begin
   // A Start/Stop gomb feliratnak megfelelen elindtjuk, illetve meglltjuk
   // (Interval = 0) az animcit, s trjuk a gomb feliratt:
    i:=1-i;
    tmrIdozito.Interval:= i*100;
    cmdStart.Caption:= szStartStop[i];
  end;
end;

procedure TForm1.mnuMiezClick(Sender: TObject);
begin
  with Screen do
    if Cursor=crDefault        // ha a kurzor alakja - egyszer nyl
      then begin
             Cursor:=crHelp;             // kurzoralak megvltoztatsa krdjeles nyll
             mnuMiEz.Checked:=true;      // menpont "kipiplsa"
           end
      else begin
             Cursor:=crDefault;  // kurzoralak megvltoztatsa egyszer nyll
             mnuMiEz.Checked:=false; // menpont  melletti pipnak eltntetse
           end;
end;

procedure TForm1.FormCreate(Sender: TObject);
var i: integer;
begin
  for i:=1 to KepSzam do
   begin
     Kocka[i]:= 0;
     ElojelesEgy[i]:= 1;
   end;
  Forgo:=1;
  KepMegjelenites(0,imlRozsa);
end;

procedure TForm1.imgKepClick(Sender: TObject);
begin
  if Screen.Cursor=crHelp then
    begin
      Application.HelpFile := 'kontext.hlp';
      Application.HelpCommand(HELP_CONTEXTPOPUP, imgKep.Tag);
    end
end;


procedure TForm1.mnuKepsorozatClick(Sender: TObject);
begin
  Forgo:=(Sender as TMenuItem).Tag;
  case Forgo of
   1: KepMegjelenites(0,imlRozsa);
   2: KepMegjelenites(0,imlKutyus);
   3: KepMegjelenites(0,imlKiadojel);
  end;
end;

end.
